library Win32DLL;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  Windows;

{$R *.res}

function DoSomething(I: Integer): Bool; cdecl;
var
  S: String;
begin
  Result := True;
  Str(I, S);
  MessageBox(0, PChar(S), 'Do Something', MB_OK or MB_ICONINFORMATION);
end;

function DoSomethingElseA(Msg: PChar): Bool; cdecl;
begin
  Result := True;
  MessageBox(0, Msg, 'Do Something Else', MB_OK or MB_ICONQUESTION);
end;

function DoSomethingElseW(Msg: PWideChar): Bool; cdecl;
begin
  Result := True;
  MessageBoxW(0, Msg, 'Do Something Else', MB_OK or MB_ICONHAND);
end;

exports
  DoSomething,
  DoSomethingElseA,
  DoSomethingElseW;

begin
end.
